/* ==== buttonHelper.ino ==== */
#include "button.h"

namespace button
{
  const unsigned long DEBOUNCE_TIME_MS = 100; // in millisecs
  const unsigned long SHORT_TIME_MS = 1000;
  const unsigned long LONG_TIME_MS = 5000;
  const unsigned long STUCK_TIME_MS = 10000;
  // This routine is non blocking so we need to s=track when the button was pressed

  bool pressed(State &state, unsigned long B_now)
  {
    static unsigned long firstPressedMs = 0;
    const bool isPressed = (digitalRead(BUTTON_A) == LOW);
    //const unsigned long now = millis();
   //  unsigned long now = millis();
   unsigned long now;
now = B_now; // ....

    if (!isPressed)
    {
      firstPressedMs = now; // reset the timer for the button if not set
      state = OFF;
      return false;
    }

    // So button isPressed (is TRUE)
    
    if (firstPressedMs == 0)
    {
      firstPressedMs = now;
      state = OFF;
      return false;
    }

    const unsigned long heldTime = now - firstPressedMs;
    // Button is down so is it debounced?
    if (heldTime < DEBOUNCE_TIME_MS)
    {
      state = OFF;
      return false;
    }
    /* Button is debounced and pressed so measure the length of time
    // A held button will return each of the following as is meets the criteria for the time held.
    */
    if (heldTime >= STUCK_TIME_MS)
      state = STUCK;
    else if (heldTime >= LONG_TIME_MS)
      state = LONG;
    else if (heldTime >= SHORT_TIME_MS)
      state = SHORT;
    else
      state = TAP;

    return true;
  }
}
