#pragma once
/*
 * pins.h
 * ------------------------------------------------------------
 * Project: Solar Water Heater Controller
 * MCU:     Arduino Nano Every (ATmega4809)
 * PCB:     ControllerPCB Rev Jan2026v2 / HW v2.2.1+
 *
 * This file is AUTHORITATIVE.
 * Any pin change must be reflected here and in the schematic.
 * ------------------------------------------------------------
 */

/* ===================== Board sanity ===================== */
#if !defined(ARDUINO_AVR_NANO_EVERY)
  #error "This firmware is intended for Arduino Nano Every only"
#endif

/* ===================== LCD (HD44780, 4-bit) ===================== */
/*
 * LCD Pinout (HD44780):
 *   RS  -> D8
 *   E   -> D9
 *   D4  -> D6
 *   D5  -> D5
 *   D6  -> D4
 *   D7  -> D3
 */
#define PIN_LCD_RS   8
#define PIN_LCD_EN   9
#define PIN_LCD_D4   6
#define PIN_LCD_D5   5
#define PIN_LCD_D6   4
#define PIN_LCD_D7   3

/* ===================== User Inputs ===================== */
// Active LOW, internal pull-up enabled
#define BUTTON_A     2

/* ===================== Outputs ===================== */
// Pump relay / NFET gate (HIGH = ON)
#define PIN_PUMP     7

// Frost LED (currently unused, driven LOW)
#define LED_FROST    10

/* ===================== Serial ===================== */
#define PIN_SERIAL_RX 0
#define PIN_SERIAL_TX 1

/* ===================== Analog Sensors ===================== */
// Temperature sensors handled in temps.h
// Analog pins not explicitly listed here are unused

/* ===================== Unused Pins (EMI / ESD hardened) ===================== */
/*
 * These pins are NOT connected on the PCB.
 * They are driven OUTPUT LOW during init to avoid floating nodes.
 */
#define UNUSED_DIGITAL_PINS { \
  11, /* MOSI */              \
  12, /* MISO */              \
  13  /* SCK  */              \
}

#define UNUSED_ANALOG_PINS { \
  A0                          \
}

/* ===================== Safety checks ===================== */
static_assert(PIN_LCD_RS != PIN_LCD_EN, "LCD RS and EN cannot share a pin");
static_assert(PIN_LCD_D4 != PIN_LCD_D5, "LCD data pins must be unique");
static_assert(PIN_LCD_D5 != PIN_LCD_D6, "LCD data pins must be unique");
static_assert(PIN_LCD_D6 != PIN_LCD_D7, "LCD data pins must be unique");
