#include <Arduino.h>  // MUST be first
#include "pump_control.h"

bool updatePump(PumpState &ps, bool requestOn, unsigned long now)
{
    // ----- HARD FAULT LOCKOUT -----
    if (ps.maxRunFault) {
        ps.running = false;
        return false;
    }

    ps.lock = false;  // default: no lock

    // ----- STATE CHANGE REQUESTED? -----
    if (ps.running != requestOn) {

        // Minimum time for the CURRENT state
        unsigned long minLimit =
            ps.running ? MIN_ON_MS : MIN_OFF_MS;

        // Too early to change?
        if (now - ps.lastChange < minLimit) {
            ps.lock = true;          // show lock icon
            return ps.running;       // refuse transition
        }

        // Transition allowed
        ps.running = requestOn;
        ps.lastChange = now;

        if (ps.running)
            ps.onStart = now;

        return ps.running;
    }

    // ----- MAX RUN TIME -----
    if (ps.running && (now - ps.onStart >= MAX_ON_MS)) {
        ps.running = false;
        ps.lastChange = now;
        ps.maxRunFault = true;
        ps.lock = true;
        return false;
    }

    return ps.running;
}
