/* ========== LCD_Helper.h =========== */
#pragma once
#include <LiquidCrystal.h>
#include <stdint.h>
#include "SystemMode.h"

namespace LCD_
{
    struct DisplayModifiers
    {
        bool scroll;
        bool blink;
        bool caps;
        bool lock;          // Override active
        bool frost;         // Frost protection active
        bool lockBlink;     // Max-run fault (flash lock only)
    };
    
    void renderTopRow(
        LiquidCrystal &lcd,
        MessageId msg,
        const char *const *messageTable,
        const DisplayModifiers &mods);

    void renderBottomRow(
        LiquidCrystal &lcd,
        int16_t tin_x10,
        int16_t tcyl_x10,
        int16_t tstag_x10);

    void printTempPos_x10(LiquidCrystal &lcd, int16_t t);
    void printTempSigned_x10(LiquidCrystal &lcd, int16_t t);
}
