/* ========== pump_control.h =========== */
#pragma once
// #define TEST_MODE   // <-- MUST be before the #ifdef

#include <Arduino.h>
constexpr unsigned long MIN_ON_MS = 5000UL;   // 5 s
constexpr unsigned long MIN_OFF_MS = 5000UL;  // 5 s

#ifdef TEST_MODE
constexpr unsigned long MAX_ON_MS = 30UL * 1000;  // 30 seconds
#else
constexpr unsigned long MAX_ON_MS = 12UL * 60 * 60 * 1000;  // 12 hours
#endif

struct PumpState {
  bool running = false;          // actual pump output state
  unsigned long lastChange = 0;  // time we entered the current state (ON or OFF)
  unsigned long onStart = 0;     // time pump last started
  bool maxRunFault = false;      // latched 12h overrun fault
  bool lock = false;             // min on/off or lock
};


bool updatePump(PumpState &ps,
                bool requestOn,  // from temps::shouldPumpRun()
                unsigned long now);